<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Member;
use App\Models\Transaksiservice;

class TransaksiServiceController extends Controller
{
    public function index()
    {
        $konsumen = Member::orderBy('nama')->get();

        return view('transaksiservice.index', compact('konsumen'));
    }
    public function data()
    {
        $transaksi_service = Transaksiservice::orderBy('id', 'desc')->get();

        return datatables()
            ->of($transaksi_service)
            ->addIndexColumn()
            ->addColumn('id_member', function ($transaksi_service) {
                return $transaksi_service->id_member;
            })
            ->addColumn('nama', function ($transaksi_service) {
                return $transaksi_service->nama;
            })
            ->addColumn('total', function ($transaksi_service) {
                return 'Rp. '. format_uang($transaksi_service->total);
            })
            ->addColumn('bayar', function ($transaksi_service) {
                return 'Rp. '. format_uang($transaksi_service->bayar, false);
            })
            ->addColumn('tanggal', function ($transaksi_service) {
                return tanggal_indonesia($transaksi_service->created_at, false);
            })
            ->addColumn('aksi', function ($transaksi_service) {
                return '
                <div class="btn-group">
                    <button onclick="showDetail(`'. route('transaksiservice.show', $transaksi_service->id) .'`)" class="btn btn-xs btn-info btn-flat"><i class="fa fa-eye"></i></button>
                    <button onclick="deleteData(`'. route('transakiservice.destroy', $transaksi_service->id) .'`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
                </div>
                ';
            })
            ->rawColumns(['aksi'])
            ->make(true);
    }
    public function create($id)
    {
        $transaksi_service = new Transaksiservice();
        $transaksi_service->id_member = $id;
        $transaksi_service->nama  = 0;
        $transaksi_service->total = 0;
        $transaksi_service->bayar       = 0;
        $transaksi_service->save();


        return redirect()->route('transaksiservice_detail
        .index');
    }
}
